﻿using SnapsLibrary;

class Ch08_09_TinyContactBookRoamingStore
{


    /// <summary>
    /// Czyści nazwę kontaktu do użycia w wyszukiwaniu 
    /// </summary>
    /// <param name="input">nazwa do wyczyszczenia</param>
    /// <returns>wyczyszczona nazwa kontaktu</returns>
    string TidyInput(string input)
    {
        input = input.Trim();
        input = input.ToLower();
        return input;
    }

    /// <summary>
    /// Pobiera kontakt z pamięci lokalnej
    /// </summary>
    /// <param name="name">nazwa do wyszukiwania</param>
    /// <param name="address">nieznaleziony adres - null, jeśli nie znaleziono</param>
    /// <param name="phone">nieznaleziony telefon - null, jeśli nie znaleziono</param>
    /// <returns>false, jeśli kontakt nie został zaneleziony</returns>
    bool FetchContact(string name, out string address, out string phone)
    {
        name = TidyInput(name);

        address = SnapsEngine.FetchStringFromRoamingStorage(itemName: name + ":adres");
        phone = SnapsEngine.FetchStringFromRoamingStorage(itemName: name + ":telefon");

        if (address == null || phone == null) return false;

        return true;
    }

    /// <summary>
    /// Zapisuje kontekt w pamięci lokalnej
    /// </summary>
    /// <param name="name">nazwa, która ma być użyta do oznaczenia elementu</param>
    /// <param name="address">adres do zapisania</param>
    /// <param name="phone">telefon do zapisania</param>
    void StoreContact(string name, string address, string phone)
    {
        name = TidyInput(name);

        SnapsEngine.SaveStringToRoamingStorage(itemName: name + ":adres",
                                            itemValue: address);
        SnapsEngine.SaveStringToRoamingStorage(itemName: name + ":telefon",
                                            itemValue: phone);
    }

    /// <summary>
    /// Prosi użytkownika o podanie informacji o kontakcie i zapisuje je
    /// </summary>
    void NewContact()
    {
        SnapsEngine.DisplayString("Wprowadź kontakt");
        string name = SnapsEngine.ReadString("Wpisz nazwę nowego kontaktu");
        string address = SnapsEngine.ReadMultiLineString("Wpisz numer telefonu dla kontaktu");
        string phone = SnapsEngine.ReadString("Enter contact phone");
        StoreContact(name: name, address: address, phone: phone);
    }

    /// <summary>
    /// Prosi użytkownika o nazwę kontaktu i wyświetla ją
    /// </summary>
    void FindContact()
    {
        // Pobiera nazwę kontaktu do wyszukania
        string name = SnapsEngine.ReadString("Wpisz nazwę kontaktu");

        // Zmienne do przechowywania pobieranych informacji o adresie i telefonie
        string contactAddress;
        string contactPhone;

        if (FetchContact(name: name, address: out contactAddress, phone: out contactPhone) == true)
        {
            // Pobrano informacje o kontakcie - wyświetlamy je
            // Pobrano informacje o kontakcie - wyświetlamy je
            // Pobrano informacje o kontakcie - wyświetlamy je
            SnapsEngine.ClearTextDisplay();

            SnapsEngine.AddLineToTextDisplay("Nazwa: " + name);
            SnapsEngine.AddLineToTextDisplay("Adres: " + contactAddress);
            SnapsEngine.AddLineToTextDisplay("Nr tel.: " + contactPhone);

            // Daje użytkownikowi możliwość przejrzenia informacji
            SnapsEngine.WaitForButton("Dalej");

            // Czyści wyświetlacz
            SnapsEngine.DisplayString("");
        }
        else
        {
            // Informuje użytkownika, że nie znaleziono nazwy
            SnapsEngine.DisplayString("Nie znaleziono podanej nazwy");
        }

        // Daje użytkownikowi możliwość przejrzenia informacji
        SnapsEngine.WaitForButton("Dalej");

        // Czyści wyświetlacz
        SnapsEngine.ClearTextDisplay();
    }

    /// <summary>
    /// Punkt wejścia programu
    /// </summary>
    public void StartProgram()
    {
        

        while (true)
        {
            SnapsEngine.SetTitleString("Niewielki spis kontaktów");

            string command = SnapsEngine.SelectFrom2Buttons("Nowy kontakt", "Znajdź kontakt");

            if (command == "Nowy kontakt")
            {
                NewContact();
            }

            if (command == "Znajdź kontakt")
            {
                FindContact();
            }
        }
    }
}